# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.containerservicefleet import ContainerServiceFleetMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-containerservicefleet
# USAGE
    python fleet_managed_namespaces_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerServiceFleetMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.fleet_managed_namespaces.begin_create_or_update(
        resource_group_name="rgfleets",
        fleet_name="fleet1",
        managed_namespace_name="namespace1",
        resource={
            "location": "eastus",
            "properties": {
                "adoptionPolicy": "Never",
                "deletePolicy": "Keep",
                "managedNamespaceProperties": {
                    "annotations": {"key2": "value2"},
                    "defaultNetworkPolicy": {"egress": "AllowAll", "ingress": "AllowSameNamespace"},
                    "defaultResourceQuota": {
                        "cpuLimit": "1",
                        "cpuRequest": "1",
                        "memoryLimit": "32Gi",
                        "memoryRequest": "10Gi",
                    },
                    "labels": {"key1": "value1"},
                },
                "propagationPolicy": {
                    "placementProfile": {
                        "defaultClusterResourcePlacement": {
                            "policy": {
                                "affinity": {
                                    "clusterAffinity": {
                                        "requiredDuringSchedulingIgnoredDuringExecution": {
                                            "clusterSelectorTerms": [
                                                {
                                                    "labelSelector": {
                                                        "matchExpressions": [
                                                            {
                                                                "key": "region",
                                                                "operator": "In",
                                                                "values": ["production1", "production2"],
                                                            }
                                                        ],
                                                        "matchLabels": {"gpu": "true"},
                                                    },
                                                    "propertySelector": {
                                                        "matchExpressions": [
                                                            {"name": "zones", "operator": "Gt", "values": ["1"]}
                                                        ]
                                                    },
                                                }
                                            ]
                                        }
                                    }
                                },
                                "placementType": "PickAll",
                                "tolerations": [
                                    {
                                        "effect": "NoSchedule",
                                        "key": "AIWorkloadOnly",
                                        "operator": "Exists",
                                        "value": "true",
                                    }
                                ],
                            }
                        }
                    },
                    "type": "Placement",
                },
                "status": {"lastOperationError": {}},
            },
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-08-01-preview/FleetManagedNamespaces_CreateOrUpdate.json
if __name__ == "__main__":
    main()
