/* readline.h
 */

/* SPDX-FileCopyrightText: 1995,1996 Sascha Demetrio
 * SPDX-FileCopyrightText: 2009, 2015, 2016 Peter Pentchev
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _READLINE_H_
#define _READLINE_H_

extern char **(*completer)(const char *prefix, const char *command,
                               char *line, int context);

extern int rl_backspace_jump;
extern int rl_cancel_on_bs;
extern int rl_redisplay;
extern void (*rl_winch)(void);

char *
readline(const char *prompt, const char *default_val, int context);

int
keys_length(void);

#endif

/* end of readline.h */


/* VIM configuration: (do not delete this line)
 *
 * vim:bk:nodg:efm=%f\:%l\:%m:hid:icon:
 * vim:sw=2:sm:textwidth=79:ul=1024:wrap:
 */
