#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2015 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Impossible Creatures
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250520.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='impossible-creatures'
GAME_NAME='Impossible Creatures'

ARCHIVE_BASE_EN_0_NAME='setup_impossible_creatures_2.2.0.5.exe'
ARCHIVE_BASE_EN_0_MD5='1b7223749a9f1fef2aac8213db2023da'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_SIZE='1400000'
ARCHIVE_BASE_EN_0_VERSION='1.1.3-gog2.2.0.5'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/impossible_creatures'

ARCHIVE_BASE_FR_0_NAME='setup_impossible_creatures_french_2.2.0.5.exe'
ARCHIVE_BASE_FR_0_MD5='ff7366c991de12339c0063817b2194da'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_SIZE='1500000'
ARCHIVE_BASE_FR_0_VERSION='1.1.3-gog2.2.0.5'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/impossible_creatures'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
drivers
rdnplugins
rdntools
pipeline.ini
*.asi
*.dll
*.exe
*.flt
*.m3d'
CONTENT_GAME_L10N_FILES='
locale
movies
ic.ini'
CONTENT_GAME_DATA_FILES='
data
datasrc
ic
insect
rankedgaming
rdnmod
sdk
ebusetup.sem
ic_stats.ico
*.module
*.sga'
CONTENT_DOC_DATA_FILES='
news.txt'
CONTENT_DOC0_DATA_RELATIVE_PATH='docs'
CONTENT_DOC0_DATA_FILES='
license
ic_mission_editor_documentation.doc
ic animal guide.pdf
ic bonus animal guide.pdf
ic control.rtf
insect invasion patch readme.rtf
readme.txt'
CONTENT_DOC1_DATA_RELATIVE_PATH='documents'
CONTENT_DOC1_DATA_FILES='
*.doc'

## Work around annoyingly long loading times. (WINE 10.0)
## cf. https://www.protondb.com/app/324680#oFK_xKHmyM
WINE_DLLOVERRIDES_DEFAULT='winemenubuilder.exe,mscoree,mshtml='
WINE_DLLOVERRIDES_DEFAULT="${WINE_DLLOVERRIDES_DEFAULT};msvcp70,msvcr70=n"

APP_MAIN_EXE='ic.exe'

APP_EDIT_ID="${GAME_ID}-mission-editor"
APP_EDIT_NAME="$GAME_NAME - Mission editor"
APP_EDIT_EXE='missioneditor.exe'

APP_CONFIG_ID="${GAME_ID}-configuration"
APP_CONFIG_NAME="$GAME_NAME - Configuration"
APP_CONFIG_CAT='Settings'
APP_CONFIG_EXE='icconfig.exe'

USER_PERSISTENT_DIRECTORIES='
playback
profiles
screenshots
stats'
USER_PERSISTENT_FILES='
*.ini'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_BASE_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Prevent the inclusion of some libraries
	## Due to the amount of libraries to include,
	## it would not be practical to set a full list
	## excluding only the following ones.
	rm \
		'gameuxinstallhelper.dll' \
		'goggame-1448280463.dll' \
		'steam_api.dll'
)

# Include game data

content_inclusion_icons 'PKG_DATA'
## Localized files are included first, as they include some DLL libraries
## that would be gobbled up by the binaries package.
content_inclusion 'GAME_L10N' 'PKG_L10N' "$(path_game_data)"
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
